; Blinker v2, (c) benj9, m65v50
; blink on events


				AREA Blinker, CODE, READONLY  
				
				EXPORT	blinker_init, p_illumi32

boot_blink_type					EQU	1  ; boot sfx: 1=yes, 0=no ### USER PATCH CONFIG ###
mainscreen_always_on_profile	EQU 5  ; mainscreen always on profile
mainscreen_always_on_brightness	EQU 30 

				CODE16

; simplified function: master_loop is running approx 1x/sec and checks for events.
; if events found, according blink engine is started. master_loop doest run meanwhile,
; last call of blink module restarts master_loop

; entry blinker_start starts dynamic_blink_module for boot effects, that starts after ending the master_loop.
		
	
; NOTE: cause the functions call each other by "CallAfterTimer", they cannot communicate by Registers, only by RAM
				
; free_ram usage:
; 0-7:	timer data 
; 8-9:	illumination toggler
; A:	DynamicBlinker polarity
; B:	NumberBlinker Start
; C:	Numberblinker Step
; D: 	MissedEventsResult (FF if not set)
; E: 	DynamicBlinker Parameter: lo value (time, 1sec=ca-225)
; F: 	DynamicBlinker Parameter: hi value (time, 1sec=ca-225)
; 10:	DynamicBlinker Parameter: step-divide-by
; 11:	DynamicBlinker Parameter: blink type
; 12:	Lock after running entryp first time
; 13:	NetBlinker wait time for next blink call. if zero, blinker blinks not when illu is on.
; 14:	Temporariliy profile permit store
; 15:	SetIllumination-Is-Called-By-Blinker message (0=false)
; 16:	Illumination State by Law (what the firmware thinks about illumination on or off)


; ========================================================================================	
; called from first entry point to start whole patch
; ========================================================================================	

				DCB		"Blinker2,benj9"

				ENTRY

blinker_init	PUSH 	{R0-R7,LR}

				LDR		R6,free_ram
				LDRB	R1,[R6,#0x12] ; first time run?
				CMP		R1,#0 ; first time run?
				BNE		blinker_x ; ram address already allocated, patch already started, dont do again

blinker_prep		 	
				;MOV		R0,#0x11 ; mem needed
				;MOV		R7,#20 ; Malloc - doesnt work at this early entryp
				;BL		_funclib
				
				; reset dest ram buffers to zero 
				; MOV		R1,#0
				; STR		R1,[R6,#8] ; set to zero? why?
				MOV		R1,#0xFF
				STRB	R1,[R6,#0x12]
								
				MOV		R2,#boot_blink_type ; boot sfx: 1=yes, 0=no ### USER PATCH CONFIG ### 
				CMP		R2,#0 ; no boot blinking
				BNE		blinker_boot
				
blinker_master	BL		master
				B		blinker_x

blinker_boot	;SUB		R1,#1  ; blink type 0=long, 1=short
				;STRB	R1,[R6,#0x11] ; blink type
				MOV		R1,#0x18 ; make the beginning a bit before fast climax. short: 0x20, long:0x10

				STRB	R1,[R6,#9] ; illumination toggle counter DynamicBlinker
				BL		dynamic_blinker ; starts after being finished booting master :)
				

blinker_x		POP 	{R0-R7}
				
repatch			MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
				POP		{PC}

; ========================================================================================	
; master loop
; ========================================================================================	
;dcb "_master_"
master			PUSH	{LR}
				BL		_get_mem_ptr
				
				MOV     R7,#2 ; GetProfile
				BL		_funclib
				ADR		R7,profiles
				LDRB	R2,[R7,R0] ; profile permit. 0=off. 1=blink events, netlost. 2=blink events, netlost, netblinker.
				STRB	R2,[R6,#0x14] ; 14:Temporariliy profile permit store
				CMP		R2,#0
				BEQ		master_patrol
	
ma_precheck		LDRB	R0,[R6,#0xD] ; stored_number_missed_events
				CMP		R0,#0xFF
				BNE		ma_precheck1
				BL		_get_number_missed_event_types	
ma_precheck1	MOV		R1,#0xFF
				STRB	R1,[R6,#0xD] ; MissedEventsResult (FF if not set)
				; R0=calculated_missed-events-result
				MOV		R3,R0
				
				CMP		R2,#1 ; profile permit for netblinker. 1=event+netlost blinker, 2=all blinker
				BEQ		ma_precheck2
				BL		_get_net_access_mode	
				MOV		R1,R0 ; R1=net-access-traffic (netaccess_idle=idle)
				B		ma_precheck3
ma_precheck2	LDR		R1,netaccess_idle ; if netblinker not permitted by profile, fake netaccess idle
				
ma_precheck3	BL		_get_net_online
				MOV		R2,R0 ; R2=net online (1=true)
				
				BL		_get_accu_icon ; R0=boot state (0=true)
	
ma_check		LDR		R7,netaccess_idle
				
				CMP		R0,#0 ; booting				
				BEQ		ma_bli_net_traf

ma_boot_no		CMP		R3,#0 ; no events
				BEQ		ma_event_no

ma_event_y		CMP		R2,#1 ; netonline
				BNE		ma_bli_event	

ma_net_online_y	CMP		R1,R7 ; netaccess_idle
				BNE		ma_bli_net_traf
				B		ma_bli_event
				
ma_event_no		CMP		R2,#1 ; netonline
				BNE		ma_bli_net_lost
				
				CMP		R1,R7 ; netaccess_idle
				BEQ		master_patrol
				B		ma_bli_net_traf
				
; ----------------------------------------------
		
ma_bli_event	CMP		R3,#3 ; 1 & 2 events 
				BGE		ma_bli_event1
				MOV		R0,R3
				BL		number_blinker 
				B		master_x
				
ma_bli_event1	MOV		R1,#1
				STRB	R1,[R6,#0x11] ; blink type
				BL		dynamic_blinker 
				B		master_x				
								
ma_bli_net_traf	BL		net_blinker
				B		master_x
				
ma_bli_net_lost	BL		netlost_blinker
				B		master_x			
	
master_patrol	MOV		R0,R6
				MOV		R1,#255 ; approx. 1.2 seconds
				LDR		R2,=master
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib		
					
master_x		POP		{PC}


; ========================================================================================	
; dynamic sweeping blinker module
; ========================================================================================	

; E: DynamicBlinker lo value (time, 1sec=ca-225)
; F: DynamicBlinker hi value (time, 1sec=ca-225)
; 10:DynamicBlinker step-divide-by
; 11:DynamicBlinker Parameter: blink type

dynamic_blinker ; input ram+0x11: blink type
				PUSH	{LR}
				BL		_get_mem_ptr
				
				MOV		R0,#0 
				STRB	R0,[R6,#0x13] ; if zero, blinker blinks not when illu is on
				
				LDRB	R0,[R6,#0x11] ; blink type
				
				CMP		R0,#0 
				BEQ		dyn_blinker_0


dyn_blinker_1	MOV		R0,#5
				MOV		R1,#0x48
				MOV		R2,#3
				B		dyn_blinker_exe

dyn_blinker_0	MOV		R0,#3
				MOV		R1,#0x60
				MOV		R2,#4
				
dyn_blinker_exe	STRB	R0,[R6,#0xE] ; lo value
				STRB	R1,[R6,#0xF] ; hi value
				STRB	R2,[R6,#0x10] ; lsr value
				
				BL		dynamic_blinker_loop

				POP		{PC}

; -----------------------------------------------------------------

dynamic_blinker_loop
				PUSH	{R0-R7,LR}

				MOV		R5,#0 ; zero dynamic_loop_x flag

				BL		_illumination_toggler
 		
dyn_on			LDRB	R1,[R6,#9] ; gespeicherter nchster Zeitwert
				LDRB	R2,[R6,#0xE] ; low value
				CMP		R1,R2
				BGE		dyn_on1 ; wenn kleiner als 4, Richtung umpolen

dyn_pol_pos		MOV		R2,#1
 				B		dyn_pol_str

dyn_on1			LDRB	R2,[R6,#0xF] ; hi value
				CMP		R1,R2 
				BLE		dyn_on2 ; wenn grer als startvalue, Richtung umpolen
		
dyn_pol_neg		MOV		R2,#0
				MOV		R5,#1 ; set dynamix_loop_x flag
dyn_pol_str 	STRB	R2,[R6,#0xA] ; polarity speichern
		
		
dyn_on2			LDRB	R2,[R6,#0x10] ; LSR-Val
				MOV		R7,R1
				LSR		R7,R2  
				ADD		R7,#1
				LDRB	R2,[R6,#0xA] ; polaritaet
				CMP		R2,#0 
				BNE		dyn_on_pos
		
dyn_on_neg		SUB		R1,R7
				B		dyn_on3
		
dyn_on_pos		ADD		R1,R7

dyn_on3			STRB	R1,[R6,#9]	; store current timeval


dyn_start_what	CMP		R5,#1 ; loop finished?
				BEQ		dyn_master
				
dyn_inner_ret	LDR     R2,=dynamic_blinker_loop ; loop not finished, go on
				B		dyn_exec3	
				
dyn_master		BL		_get_number_missed_event_types
				CMP		R0,#0
				BNE		dyn_master_ret

dyn_law			BL		_set_illumination_state_to_law
			
dyn_master_ret	LDR     R2,=master
				B		dyn_exec3

; dyn_selfstarter	LDR     R2,=dynamic_blinker ; +1 ; restart myself directly while booting
		
dyn_exec3		MOV		R0,R6
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
		
dynamic_loop_x	POP		{R0-R7,PC}	

			

; ========================================================================================	
; missed events numbers / netlost blinker module
; ========================================================================================	

; entry for missed events 1-2

number_blinker	PUSH	{R0-R7,LR} ; input r0=number of missed events

				CMP		R0,#1 ; 1 event
				BEQ		number_1
				
number_2		MOV		R0,#24
				B		number_do
				
number_1		MOV		R0,#72

number_do		BL		_get_mem_ptr

				MOV		R1,#0 
				STRB	R1,[R6,#0x13] ; if zero, blinker blinks not when illu is on
				
				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler

				STRB	R0,[R6,#0xC] ; Numberblinker Step
				MOV		R0,#72
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}


; -----------------------------------------------------------------

; entry for netlost blinker

netlost_blinker	PUSH	{R0-R7,LR}
				BL		_get_mem_ptr
				MOV		R1,#0 
				STRB	R1,[R6,#0x13] ; if zero, blinker blinks not when illu is on
				
				MOV		R1,#0xA ; short duration
				STRB	R1,[R6,#0xB] ; NumberBlinker Remainder
				MOV		R1,#0xA ; short bleep
				STRB	R1,[R6,#0xC] ; Numberblinker Step

				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}

; -----------------------------------------------------------------

number_blinker_loop ; inner blinking module
				PUSH	{LR}
		
				BL		_illumination_toggler

				LDRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				LDRB	R1,[R6,#0xC] ; Numberblinker Step 
				SUB		R0,R1
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				CMP		R0,#0
				BMI		number_blinker_return
				
				LDR		R2,=number_blinker_loop
				B		number_exec1

number_blinker_return
				BL		_get_number_missed_event_types
				CMP		R0,#0
				BNE		number_exec
				
				BL		_get_net_online
				CMP		R0,#0
				BEQ		number_exec
				
				BL		_set_illumination_state_to_law

number_exec		MOV		R1,#225 
				ADD		R1,#225 ; Dauer, 450/250 Sekunden
				LDR		R2,=master			
				
number_exec1	MOV		R0,R6
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
				
				POP		{PC}
				
; ========================================================================================	
; net-blinker module
; ========================================================================================	
;dcb "_netbli_"
net_blinker		PUSH	{LR} 

				; method with direct netaccess_mode byte
				BL		_get_net_access_mode	
				CMP		R0,#5
				BLE		net_blinker0
				
				SUB		R0,#6
				LSL		R0,#2
				ADD		R0,#0xA
				B		net_blinker1
net_blinker0	ADD		R0,#3
				CMP		R0,#6
				BGE		net_blinker1
				
				ADD		R0,#7

				; method with netaccess_mode - 0x68 byte
				;BL		_get_net_access_mode	
				;ADR		R1,net_bli_data
				;LDRB	R1,[R1,R0] ; get time value
				;CMP		R0,#8
				;BLE		net_blinker1
				
				;MOV		R1,#0x50 ; slooow blinking				
net_blinker1	; MOV		R0,R1			
				
net_bli_what	STRB	R0,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on
				BL		_get_net_access_mode
				LDR		R7,netaccess_idle
				CMP		R0,R7 ;idle value
				BEQ		net_bli_mastr_r
				
				PUSH	{R0}
				BL		_get_net_online
				MOV		R1,R0 ; R1=net online (1=true)
				BL		_get_accu_icon ; R0=boot state (0=true)
				MOV		R3,R0 ; R3=booting (0=true)               
				POP		{R0}
				
				LDRB	R2,[R6,#0x14] ; 14:Temporariliy profile permit store
				CMP		R2,#2 ; profile permit for netblinker. 1=event+netlost blinker, 2=all blinker
				BNE		net_bli_mastr_r	
				
				CMP		R3,#0 ; if bootin, go                 
				BEQ		net_bli_inner_r
				
				CMP		R1,#0 ; netlost, not booting: no
				BEQ		net_bli_mastr_r
				
net_bli_inner_r	BL		_illumination_toggler
				LDR		R2,=net_blinker
				B		net_bli_go

net_bli_mastr_r	BL		_set_illumination_state_to_law
				LDR		R2,=master

net_bli_go		LDRB	R1,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on.
				MOV		R0,R6
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib		
				POP		{PC}
 ALIGN
; net_bli_data	dcb		0xB,0x6,0x12,0x1A,0x30,8,0x38,0xE,0x40
 ALIGN
netaccess_idle	DCD 0x13 ; idle val for netaccessmode2


; ========================================================================================	
; auxiliary functions
; ========================================================================================	


_funclib		PUSH	{R6-R7,LR} ; input: R7  = func#
				LDR		R6,FunctionLibrary
				LSL		R7,#3
				ADD		R7,R6
				LDR		R7,[R7,#4]
				BLX		R7
				POP		{R6-R7,PC}
	
; ----------------------------------------------------------------------	

_get_number_missed_event_types
				PUSH	{R1-R7,LR}

				MOV		R0,#0 ; otherwise crash
				LDR		R7,Get_MainscreenNumberOfMissedEventTypes
				BLX		R7
				LDR		R7,ram_Mainscreen_NumberOfMissedEventTypes
				LDR		R0,[R7]
				BL		_get_mem_ptr

				;LDRB 	R0,[R6,#0x18] ; for testing

				STRB	R0,[R6,#0xD]	
				POP		{R1-R7,PC}

; ----------------------------------------------------------------------

_get_mem_ptr	LDR		R6,free_ram
				; LDR		R6,[R6]
				BX		LR

; ----------------------------------------------------------------------

_set_illumination
				PUSH	{R1,R7,LR}
				MOV		R1,#1
				MOV		R3,#0x28
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
				POP		{R1,R7,PC}

; ----------------------------------------------------------------------	

_get_illumination_state_by_law
				PUSH	{LR}
				; MOV		R7,#82 ; Get_IlluminationDataTable
				; BL		_funclib
				LDR		R7,_get_illumination_data_table
				BLX		R7
				ADD		R0,#0x94
				LDRB	R0,[R0]  ; +0x94: What OS thinks is state of Illumination On/Off
				POP		{PC}


; ----------------------------------------------------------------------	

_set_illumination_state_to_law
				PUSH	{R0-R7,LR}			
			 	BL		_get_illumination_state_by_law 
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		_set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		_set_illumination
		   	    POP		{R0-R7,PC}
		   	    
; ----------------------------------------------------------------------	

_illumination_toggler
				PUSH	{R0,LR}
				BL		_get_mem_ptr
				
				LDRB	R0,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on, but yes, if booting.
				CMP		R0,#0 ; TimedBlinker not active?
				BNE		_illu_toggl_ok
				
_illu_toggl_1	BL		_get_illumination_state_by_law
				CMP		R0,#0
				BEQ		_illu_toggl_ok
			
				BL		_get_accu_icon
				CMP		R0,#0 ; booting?
				BNE		_illu_toggl_x
							
_illu_toggl_ok	LDRB	R2,[R6,#8] ; Brightness-Toggler, msste man boolsch machen, falls Profilwechsel/Brightnesswechsel
				MOV		R1,#60 ; brightness
				SUB		R0,R1,R2
				STRB	R0,[R6,#8]
				MOV		R0,#0x01 ; output device
				MOV		R1,#1
				MOV		R3,#0x28
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
_illu_toggl_x	POP		{R0,PC}
		
; -----------------------------------------------------------

_get_net_online	LDR		R0,_ram_net_online
				LDRB	R0,[R0]
				
				;LDRB	R0,[R6,#0x19] ; for testing
				BX		LR
				
; -----------------------------------------------------------------------------

_get_accu_icon	LDR		R0,_ram_mainscreen_accu_icon_ 
				;LDR		R0,[R0] ; base address mainscreen state
				LDRH	R0,[R0]
				BX		LR
				
; -----------------------------------------------------------------------------

_get_net_access_mode	
				PUSH	{LR}
				;MOV		R7,#81 ; _get_net_access_
				; BL		_funclib
				LDR		R7,_get_net_access_
				BLX		R7
				POP		{PC}
				
; ========================================================================================	
; ========================================================================================	
; SetIllumination Patch
; ========================================================================================	

				
p_illumi16		MOV		R7,#2 ; GetProfile
				BL		_funclib
				MOV		R3,R0
				POP		{R0-R2}
				
				CMP		R3,#mainscreen_always_on_profile
				BNE		p_illumi16_x
				
				CMP		R6,#0 ; in SetIllu-Call no permit
				BEQ		p_illumi16_x 
				
				CMP		R0,#0 
				BNE		p_illumi16_x ; SetIllumination-Call is not Mainscreen
				
				CMP		R4,#0
				BNE		p_illumi16_x ; SetIllumination-Call is Mainscreen On

				MOV		R4,#mainscreen_always_on_brightness

p_illumi16_x	MOV		R7,R0 ; repatch
				POP		{R5,R6,PC}	; repatch & return to SetIllumination Entrypoint		
				
; -----------------------------------------------------------------------------
; Called by SetIllumination Entrypoint
; -----------------------------------------------------------------------------
				CODE32
p_illumi32		STMFD	SP!,{R0-R2,R5,R6,LR}
				LDR		R7,=p_illumi16
				BX		R7
;				; LDMFD	SP!,{PC} ; p_illumi16 does POP PC
		
; -----------------------------------------------------------------------------

 ALIGN
profiles		DCB		2,1,0,2,0,2,0,0xFF ; profiles 1-7:  0=off. 1=event+netlost-blinker. 2=event+netlost+netblinker

; -----------------------------------------------------------------------------

Get_MainscreenNumberOfMissedEventTypes		DCD 0xA163A08F  ; s65v58: A169F14B. sl65v50:  A16486B3
;(00AB19780120022900D0002098BDF8B5)+0xF
 
ram_Mainscreen_NumberOfMissedEventTypes		DCD 0xA867C860 ; s65v58: A86D0670 , sl65v50: A867633C
; A1634030 2E 48                       LDR     R0, =ramram_Mainscreen_NumberOfMissedEventTypes
; (0136A642EED39999006803) + 6, there you find the address loaded.


_ram_mainscreen_accu_icon_				DCD 0xA863A544 ; s65v58: A868C4E4, sl65v50: A863A3D0
; A1633BF2 46 49                       LDR     R1, =ram_mainscreen_states    + 4
; (7047B0B599999999006899990028)+0xA there you find an address loaded. add 4 to address.


;;;_ram_illumination_data					DCD 0xA866F094
;;; A1226224 CC E3 9F E5                 LDR     LR, =RAM_Illumination_Data
_get_illumination_data_table			DCD	0xA1226518 ; s65v58: A1241448  , sl65v50: A122DE48
; (00B0CAE571FFFFEA999999991EFF2FE1F04D) + 8. (internally done in Blinker: adds 0x94 to address returned by function)


_ram_net_online							DCD	0xA863D124  ; s65v58: A8690BF0, sl65v50: A863CFB0
; A1634130 27 48                       LDR     R0, =ram_Net_Online
; (70B59999999900680028) + 2

;ram_netaccess_mode						DCD 0xA87525C8
;A132D75C             _get_net_access
_get_net_access_						DCD	0xA132D75D ; s65v58: A136D5B4, sl65v50:A1339034
;(9999021C09780120914200D000207047999900787047)+0x10 you find a LDR loading the address or you can start the function.

; -----------------------------------------------------------------------------

FunctionLibrary							DCD	0xA0FC0000	   	    
free_ram								DCD	0xA8000230
	
 END  
 
 ; sl65v50:  a166F700

;ram_netaccess_mode2						DCD 0xA8752560
; A1329A26 5F 4A                       LDR     R2, =ram_netaccess_mode2_plus4 ; add 4 to "R2=" address. the content should be normally 1B, but changing, if net traffic (phoning) occurs, check!

				
			



				

